<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'bookings',
    'route'
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'bookings',
    'route'
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>
<div class="table-responsive">
    <table id="datatable" class="table table-bordered text-nowrap border-bottom">
        <thead>
            <tr>
                <th class="border-bottom-0">Booking ID</th>

                <th class="border-bottom-0">Package</th>
                <th class="border-bottom-0">Paid Amount</th>
                <th class="border-bottom-0">Total Travelers</th>
                <th class="border-bottom-0">Tour Date</th>
                <th class="border-bottom-0">Status</th>
                <th class="border-bottom-0">Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <a href="<?php echo e(route($route, $booking->id)); ?>"><?php echo e($booking->trnx_id); ?></a>
                </td>
                <td><?php echo e(word_limit($booking->package->name, 5)); ?></td>
                <td><?php echo e(number_format($booking->amount, 2)); ?>/<?php echo e(number_format($booking->amount_paid, 2)); ?></td>
                <td><?php echo e($booking->peoples); ?></td>
                <td><?php echo e($booking->package->start_date->format('d M Y')); ?></td>
                <td>
                    <?php if($booking->status == 'pending'): ?>
                    <span class="badge bg-warning">Pending</span>
                    <?php elseif($booking->status == 'approved'): ?>
                    <span class="badge bg-success">Approved</span>
                    <?php elseif($booking->status == 'rejected'): ?>
                    <span class="badge bg-danger">Rejected</span>
                    <?php elseif($booking->status == 'completed'): ?>
                    <span class="badge bg-info">Completed</span>
                    <?php endif; ?>
                </td>
                <td>
                    <a href="<?php echo e(route($route, $booking->id)); ?>" class="btn btn-primary btn-sm">Details</a>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>


<?php $__env->startPush('script'); ?>
<?php if (isset($component)) { $__componentOriginal98b18b5d7b0faeaeec5630b901fb8275 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal98b18b5d7b0faeaeec5630b901fb8275 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.datatable-js','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('datatable-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal98b18b5d7b0faeaeec5630b901fb8275)): ?>
<?php $attributes = $__attributesOriginal98b18b5d7b0faeaeec5630b901fb8275; ?>
<?php unset($__attributesOriginal98b18b5d7b0faeaeec5630b901fb8275); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal98b18b5d7b0faeaeec5630b901fb8275)): ?>
<?php $component = $__componentOriginal98b18b5d7b0faeaeec5630b901fb8275; ?>
<?php unset($__componentOriginal98b18b5d7b0faeaeec5630b901fb8275); ?>
<?php endif; ?>
<?php if (isset($component)) { $__componentOriginalbe487e1eb517593675038e98cc734e06 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbe487e1eb517593675038e98cc734e06 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.confirm-js','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirm-js'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbe487e1eb517593675038e98cc734e06)): ?>
<?php $attributes = $__attributesOriginalbe487e1eb517593675038e98cc734e06; ?>
<?php unset($__attributesOriginalbe487e1eb517593675038e98cc734e06); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbe487e1eb517593675038e98cc734e06)): ?>
<?php $component = $__componentOriginalbe487e1eb517593675038e98cc734e06; ?>
<?php unset($__componentOriginalbe487e1eb517593675038e98cc734e06); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>
<?php /**PATH C:\Users\JIASAN\Herd\bdtravel\resources\views/components/table/booking.blade.php ENDPATH**/ ?>